mining_mode = false
mining_delay = 0

function printTable(table)
    for i = 1, #table do
        for j = 1, #table[i] do
            if type(table[i][j]) == "table" then
                for k, v in ipairs(table[i][j]) do
                    --io.write("Inner[" .. k .. "]: " .. tostring(v) .. "\t")
                end
            else
                io.write(table[i][j] .. "\t")
            end
        end
        io.write("\n")
    end
end

function printArray(arr)
    for i = 1, #arr do
        print(arr[i])
    end
end

function buildResultsTransmissionTable(results, results_structure)
    transmission_table = {}
    for i = 1, 3 do
        transmission_table[i] = {}
    end

    transmission_table[1][1] = "Current Coordinates: "
    transmission_table[1][2] = ("0,0,0")
    while transmission_table[1][2] == ("0,0,0") do
        transmission_table[1][2] = tostring(vector.new(gps.locate()))
    end

    if results_structure == "default" then
        transmission_table[2][1] = "Success: "
        transmission_table[2][2] = tostring(results[1])
        transmission_table[3][1] = "Failure Reason: "
        transmission_table[3][2] = tostring(results[2])
        
    elseif results_structure == "single_response" then
        transmission_table[2][1] = "Success: "
        transmission_table[2][2] = tostring(results[1])

    elseif results_structure == "inspect" then
        transmission_table[2][1] = "Success: "
        transmission_table[2][2] = tostring(results[1])
        transmission_table[3][1] = "Block Type: "

        if (tostring(results[2].name) ~= "nil") then
            transmission_table[3][2] = results[2].name
        else
            transmission_table[3][2] = "minecraft:air"
        end

    elseif results_structure == "mining_mode" then
        transmission_table[2][1]= "Success: "
        transmission_table[2][2]= tostring(results[1])
        transmission_table[3][1]= "Mining Mode: "
        transmission_table[3][2]= tostring(results[2])
    end

    return transmission_table
end

function resolveCommand(command)
    results = {}
    results_structure = "default"

    if command == "xyz_ping" then
        results = {1}
        results_structure = "single_response"

    elseif command == "turtle.forward()" then
        results = {turtle.forward()}

    elseif command == "turtle.back()" then
        results = {turtle.back()}

    elseif command == "turtle.turnLeft()" then
        results = {turtle.turnLeft()}

    elseif command == "turtle.turnRight()" then
        results = {turtle.turnRight()}

    elseif command == "turtle.up()" then
        results = {turtle.up()}

    elseif command == "turtle.down()" then
        results = {turtle.down()}

    elseif command == "turtle.detect()" then
        results = {turtle.detect()}
        results_structure = "single_response"

    elseif command == "turtle.inspect()" then
        results = {turtle.inspect()}
        results_structure = "inspect"

    elseif command == "turtle.inspectUp()" then
        results = {turtle.inspectUp()}
        results_structure = "inspect"

    elseif command == "turtle.inspectDown()" then
        results = {turtle.inspectDown()}
        results_structure = "inspect"

    elseif command == "turtle.getFuelLevel()" then
        results = {turtle.getFuelLevel()}
        results_structure = "single_response"

    elseif command == "turtle.refuel()" then
        results = {turtle.refuel()}
        results_structure = "single_response"

    elseif command == "turtle.suck()" then
        results = {turtle.suck()}

    elseif command == "turtle.getFuelLevel()" then
        results = {turtle.getFuelLevel()}
        results_structure = "single_response"

    elseif command == "depositItems()" then
        results[1] = false
        results[1] = depositItems()
        results_structure = "single_response"

    elseif command == "dropJunk()" then
        results[1] = false
        results[1] = dropJunk()
        results_structure = "single_response"
    
    elseif command == "raw_command" then
        results = {pcall(loadstring(command))}
        results_structure = "single_response"

    elseif command == "toggleMiningMode()" then
        results[1] = false
        results[1] = toggleMiningMode()
        results[2] = mining_mode
        results_structure = "mining_mode"

    elseif command == "disableMiningMode()" then
        results[1] = false
        results[1] = disableMiningMode()
        results[2] = mining_mode
        results_structure = "mining_mode"

    else
        results[1] = false
        results[2] = "Unable to resolve command"

    end
    return buildResultsTransmissionTable(results, results_structure)
end

function getJunkItemsTable()
    junk_items_table = {}
    junk_items_table[1] = "minecraft:netherrack"
    junk_items_table[2] = "minecraft:gravel"
    junk_items_table[3] = "minecraft:blackstone"
    junk_items_table[4] = "minecraft:gold_nugget"
    junk_items_table[5] = "minecraft:basalt"
    junk_items_table[6] = "minecraft:cobblestone"
    junk_items_table[7] = "minecraft:sand"
    junk_items_table[8] = "minecraft:cobbled_deepslate"
    junk_items_table[9] = "minecraft:flint"
    junk_items_table[10] = "minecraft:dirt"
    junk_items_table[11] = "minecraft:stone"
    junk_items_table[12] = "minecraft:wheat_seeds"
    junk_items_table[13] = "minecraft:diorite"
    junk_items_table[14] = "minecraft:granite"
    junk_items_table[15] = "minecraft:andesite"
    junk_items_table[16] = "minecraft:coal"
    junk_items_table[17] = "minecraft:raw_iron"
    junk_items_table[18] = "minecraft:tuff"
    junk_items_table[19] = "minecraft:raw_copper"
    junk_items_table[20] = "minecraft:calcite"
    junk_items_table[21] = "minecraft:limestone"
    return junk_items_table
end

function depositItems()
    max_slots = 16
    for i = 1, max_slots do
        turtle.select(i)
        turtle.drop()
    end
    return true
end

function dropJunk()
    max_slots = 16
    junk_items_table = getJunkItemsTable()
    for i = 1, max_slots do
        item_in_slot = turtle.getItemDetail(i)
        if (item_in_slot ~= nil) then
            item_in_slot_name = item_in_slot.name
            for j = 1, #junk_items_table do 
                if (item_in_slot_name == junk_items_table[j]) then
                    turtle.select(i)
                    turtle.drop()
                end
            end
        end
    end
    turtle.select(1)
    return true
end

function toggleMiningMode()
    if mining_mode == true then
        mining_mode = false
    elseif mining_mode == false then
        mining_mode = true
    end
    return true
end

function disableMiningMode()
    mining_mode = false
    return true
end

function getNoDigWhitelist()
    no_dig_whitelist = {}
    no_dig_whitelist[1] = "computercraft:turtle_advanced"
    no_dig_whitelist[2] = "computercraft:computer_advanced"
    no_dig_whitelist[3] = "computercraft:wireless_modem_advanced"
    no_dig_whitelist[4] = "waystones:waystone"
    no_dig_whitelist[5] = "minecraft:torch"
    no_dig_whitelist[6] = "chunkloaders:ultimate_chunk_loader"
    no_dig_whitelist[7] = "storagedrawers:dark_oak_full_drawers_1"
    no_dig_whitelist[8] = "storagedrawers:dark_oak_full_drawers_4"
    no_dig_whitelist[9] = "storagedrawers:controller"
    no_dig_whitelist[10] = "securitycraft:sentry"
    no_dig_whitelist[11] = "storagedrawers:compacting_drawers_3"

    return no_dig_whitelist
end

function miningModeEngaged()
    no_dig_whitelist = getNoDigWhitelist()
    dig_up = true
    dig_forward = true
    dig_down = true
    s1, up_block = turtle.inspectUp()
    s2, forward_block = turtle.inspect()
    s3, down_block = turtle.inspectDown()
    for i = 1, #no_dig_whitelist do
        if up_block.name == no_dig_whitelist[i] then
            dig_up = false
        end
        if forward_block.name == no_dig_whitelist[i] then
            dig_forward = false
        end
        if down_block.name == no_dig_whitelist[i] then
            dig_down = false
        end
    end
    if dig_up == true then
        while ((up_block.name ~= nil) and (up_block.name ~= "minecraft:water") and (up_block.name ~= "minecraft:lava")) do
            turtle.digUp()
            os.sleep(mining_delay)
            s1, up_block = turtle.inspectUp()
        end
    end
    if dig_forward == true then
        while ((forward_block.name ~= nil) and (forward_block.name ~= "minecraft:water") and (forward_block.name ~= "minecraft:lava")) do
            turtle.dig()
            os.sleep(mining_delay)
            s2, forward_block = turtle.inspect()
        end
    end
    if dig_down == true then
        while ((down_block.name ~= nil) and (down_block.name ~= "minecraft:water") and (down_block.name ~= "minecraft:lava")) do
            turtle.digDown()
            os.sleep(mining_delay)
            s3, down_block = turtle.inspectDown()
        end
    end
end

function getCommand()
    rednet.open("right")
    print("listening for a new command")
    sender_id, command, protocol = rednet.receive("to_turtle" .. tostring(os.getComputerID()),5)
    if command == nil then
        print("rebroadcasting last result")
        return
    end
    io.write("Command: ")
    print(command)
    command_results = resolveCommand(command)   
    print("[------ Results Table ------]")
    printTable(command_results)
    if mining_mode == true then
        miningModeEngaged()
    end 
    rednet.broadcast(command_results,"from_turtle" .. tostring(os.getComputerID()))
    return command
end

function main()
    os.setComputerLabel("ID: " .. os.getComputerID())
    command_log = {}
    while true do
        command = getCommand()
        if command ~= nil then
            table.insert(command_log,command)
        elseif command == nil then
            rednet.broadcast(command_log[#command_log],"from_turtle" .. tostring(os.getComputerID()))
        end

    end
end

main()